/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.elasticsearch.ElasticsearchComponent;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchEndpoint.class);
    private Node node;
    private Client client;
    private ElasticsearchConfiguration config;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, Map<String, Object> parameters) throws Exception {
        super(uri, (Component)component);
        this.config = new ElasticsearchConfiguration(new URI(uri), parameters);
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume to a ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.config.isLocal()) {
            LOG.info("Starting local ElasticSearch server");
        } else {
            LOG.info("Joining ElasticSearch cluster " + this.config.getClusterName());
        }
        this.node = this.config.buildNode();
        if (this.config.getIp() != null && !this.config.isLocal()) {
            Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.config.getClusterName()).put("node.client", true).build();
            TransportClient client = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.config.getIp(), this.config.getPort().intValue()));
            this.client = client;
        } else {
            this.client = this.node.client();
        }
    }

    protected void doStop() throws Exception {
        if (this.config.isLocal()) {
            LOG.info("Stopping local ElasticSearch server");
        } else {
            LOG.info("Leaving ElasticSearch cluster " + this.config.getClusterName());
        }
        this.client.close();
        this.node.close();
        super.doStop();
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticsearchConfiguration getConfig() {
        return this.config;
    }

    public void setOperation(String operation) {
        this.config.setOperation(operation);
    }
}

