/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.fop.FopComponent;
import org.apache.camel.component.fop.FopProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.SAXException;

public class FopEndpoint
extends DefaultEndpoint {
    private String userConfigURL;
    private FopFactory fopFactory;
    private String remaining;

    public FopEndpoint(String uri, FopComponent component, String remaining) {
        super(uri, (Component)component);
        this.remaining = remaining;
    }

    public Producer createProducer() throws Exception {
        return new FopProducer(this, this.fopFactory, this.remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for FOP endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    FopFactory getFopFactory() {
        return this.fopFactory;
    }

    public void setUserConfigURL(String userConfigURL) {
        this.userConfigURL = userConfigURL;
    }

    private static void updateConfigurations(InputStream is, FopFactory fopFactory) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        Configuration cfg = cfgBuilder.build(is);
        fopFactory.setUserConfig(cfg);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.fopFactory == null) {
            this.fopFactory = FopFactory.newInstance();
        }
        if (this.userConfigURL != null) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.userConfigURL);
            FopEndpoint.updateConfigurations(is, this.fopFactory);
        }
    }
}

