/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.apache.camel.component.http.helper.HttpHelper;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJettyHttpBinding
implements JettyHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    private boolean throwExceptionOnFailure;
    private boolean transferException;

    @Override
    public void populateResponse(Exchange exchange, JettyContentExchange httpExchange) throws Exception {
        int responseCode = httpExchange.getResponseStatus();
        LOG.debug("HTTP responseCode: {}", (Object)responseCode);
        Message in = exchange.getIn();
        if (!this.isThrowExceptionOnFailure()) {
            this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
        } else if (responseCode >= 100 && responseCode < 300) {
            this.populateResponse(exchange, httpExchange, in, this.getHeaderFilterStrategy(), responseCode);
        } else {
            throw this.populateHttpOperationFailedException(exchange, httpExchange, responseCode);
        }
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    @Override
    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    @Override
    public boolean isTransferException() {
        return this.transferException;
    }

    @Override
    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    protected void populateResponse(Exchange exchange, JettyContentExchange httpExchange, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException {
        Message answer = exchange.getOut();
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        Enumeration names = httpExchange.getResponseFields().getFieldNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = httpExchange.getResponseFields().getValues(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (name.toLowerCase().equals("content-type")) {
                    name = "Content-Type";
                }
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)value);
            }
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (boolean)false);
        answer.setBody(this.extractResponseBody(exchange, httpExchange));
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, JettyContentExchange httpExchange, int responseCode) throws IOException {
        String locationHeader;
        String uri = httpExchange.getUrl();
        Map<String, String> headers = httpExchange.getHeaders();
        Object responseBody = this.extractResponseBody(exchange, httpExchange);
        if (this.transferException && responseBody != null && responseBody instanceof Exception) {
            return (Exception)responseBody;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        HttpOperationFailedException answer = responseCode >= 300 && responseCode < 400 ? ((locationHeader = httpExchange.getResponseFields().getStringField("location")) != null ? new HttpOperationFailedException(uri, responseCode, null, locationHeader, headers, copy) : new HttpOperationFailedException(uri, responseCode, null, null, headers, copy)) : new HttpOperationFailedException(uri, responseCode, null, null, headers, copy);
        return answer;
    }

    protected Object extractResponseBody(Exchange exchange, JettyContentExchange httpExchange) throws IOException {
        String contentType = httpExchange.getHeaders().get("Content-Type");
        if (contentType != null && "application/x-java-serialized-object".equals(contentType)) {
            try {
                InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)httpExchange.getResponseContentBytes());
                return HttpHelper.deserializeJavaObjectFromStream((InputStream)is);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot deserialize body to Java object", (Throwable)e);
            }
        }
        return httpExchange.getBody();
    }
}

