/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.EventBus;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;

public class GuavaEventBusProducer
extends DefaultProducer {
    private final EventBus eventBus;

    public GuavaEventBusProducer(Endpoint endpoint, EventBus eventBus) {
        super(endpoint);
        this.eventBus = eventBus;
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body != null) {
            this.log.debug("Posting: {} to EventBus: {}", body, (Object)this.eventBus);
            this.eventBus.post(body);
        } else {
            this.log.debug("Body is null, cannot post to EventBus");
        }
    }
}

