/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.websocket.WebsocketEndpoint;
import org.apache.camel.component.websocket.WebsocketProducerConsumer;
import org.apache.camel.impl.DefaultConsumer;

public class WebsocketConsumer
extends DefaultConsumer
implements WebsocketProducerConsumer {
    private final WebsocketEndpoint endpoint;

    public WebsocketConsumer(WebsocketEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect(this);
    }

    public void doStop() throws Exception {
        this.endpoint.disconnect(this);
        super.doStop();
    }

    @Override
    public WebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getPath() {
        return this.endpoint.getPath();
    }

    public void sendMessage(String connectionKey, String message) {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("websocket.connectionKey", (Object)connectionKey);
        exchange.getIn().setBody((Object)message);
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    WebsocketConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }
}

