/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.IllegalHeaderException;
import org.apache.camel.component.sjms.jms.JmsMessageType;
import org.apache.camel.component.sjms.jms.KeyFormatStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageHelper {
    public static final String JMS_CORRELATION_ID = "JMSCorrelationID";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_DESTINATION = "JMSDestination";
    public static final String JMS_EXPIRATION = "JMSExpiration";
    public static final String JMS_MESSAGE_ID = "JMSMessageID";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String JMS_REDELIVERED = "JMSRedelivered";
    public static final String JMS_REPLY_TO = "JMSReplyTo";
    public static final String JMS_TIMESTAMP = "JMSTimestamp";
    public static final String JMS_TYPE = "JMSType";
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageHelper.class);

    private JmsMessageHelper() {
    }

    public static Message createMessage(Session session, Object payload, Map<String, Object> messageHeaders, KeyFormatStrategy keyFormatStrategy) throws Exception {
        return JmsMessageHelper.createMessage(session, payload, messageHeaders, keyFormatStrategy, false);
    }

    public static Message createMessage(Session session, Object payload, Map<String, Object> messageHeaders, KeyFormatStrategy keyFormatStrategy, boolean allowNullBody) throws Exception {
        Message answer = null;
        JmsMessageType messageType = JmsMessageHelper.discoverMessgeTypeFromPayload(payload);
        try {
            switch (messageType) {
                case Bytes: {
                    BytesMessage bytesMessage = session.createBytesMessage();
                    bytesMessage.writeBytes((byte[])payload);
                    answer = bytesMessage;
                    break;
                }
                case Map: {
                    MapMessage mapMessage = session.createMapMessage();
                    Map objMap = (Map)payload;
                    Set keys = objMap.keySet();
                    for (String key : keys) {
                        Object value = objMap.get(key);
                        mapMessage.setObject(key, value);
                    }
                    answer = mapMessage;
                    break;
                }
                case Object: {
                    ObjectMessage objectMessage = session.createObjectMessage();
                    objectMessage.setObject((Serializable)payload);
                    answer = objectMessage;
                    break;
                }
                case Text: {
                    TextMessage textMessage = session.createTextMessage();
                    textMessage.setText((String)payload);
                    answer = textMessage;
                    break;
                }
                case Message: {
                    if (allowNullBody && payload == null) {
                        answer = session.createMessage();
                        break;
                    }
                    if (payload != null) {
                        throw new JMSException("Unsupported message body type " + ObjectHelper.classCanonicalName((Object)payload));
                    }
                    throw new JMSException("Null body is not allowed");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating a message of type: " + messageType.toString());
            throw e;
        }
        if (messageHeaders != null && !messageHeaders.isEmpty()) {
            answer = JmsMessageHelper.setJmsMessageHeaders(answer, messageHeaders, keyFormatStrategy);
        }
        return answer;
    }

    public static Message setJmsMessageHeaders(Message jmsMessage, Map<String, Object> messageHeaders, KeyFormatStrategy keyFormatStrategy) throws IllegalHeaderException {
        KeyFormatStrategy localKeyFormatStrategy = null;
        localKeyFormatStrategy = keyFormatStrategy == null ? new DefaultJmsKeyFormatStrategy() : keyFormatStrategy;
        HashMap<String, Object> headers = new HashMap<String, Object>(messageHeaders);
        Set keys = headers.keySet();
        for (String headerName : keys) {
            Object headerValue = headers.get(headerName);
            if (headerName.equalsIgnoreCase(JMS_CORRELATION_ID)) {
                if (headerValue == null) {
                    JmsMessageHelper.setCorrelationId(jmsMessage, null);
                    continue;
                }
                if (headerValue instanceof String) {
                    JmsMessageHelper.setCorrelationId(jmsMessage, (String)headerValue);
                    continue;
                }
                throw new IllegalHeaderException("The JMSCorrelationID must either be a String or null.  Found: " + headerValue.getClass().getName());
            }
            if (headerName.equalsIgnoreCase(JMS_REPLY_TO)) {
                if (!(headerValue instanceof String)) continue;
                continue;
            }
            if (headerName.equalsIgnoreCase(JMS_TYPE)) {
                if (headerValue == null) {
                    JmsMessageHelper.setMessageType(jmsMessage, null);
                    continue;
                }
                if (headerValue instanceof String) {
                    JmsMessageHelper.setMessageType(jmsMessage, (String)headerValue);
                    continue;
                }
                throw new IllegalHeaderException("The JMSType must either be a String or null.  Found: " + headerValue.getClass().getName());
            }
            if (headerName.equalsIgnoreCase(JMS_PRIORITY)) {
                if (headerValue instanceof Integer) {
                    try {
                        jmsMessage.setJMSPriority(((Integer)headerValue).intValue());
                        continue;
                    }
                    catch (JMSException e) {
                        throw new IllegalHeaderException("Failed to set the JMSPriority header. Cause: " + e.getLocalizedMessage(), e);
                    }
                }
                throw new IllegalHeaderException("The JMSPriority must be a Integer.  Type found: " + headerValue.getClass().getName());
            }
            if (headerName.equalsIgnoreCase(JMS_DELIVERY_MODE)) {
                try {
                    JmsMessageHelper.setJMSDeliveryMode(jmsMessage, headerValue);
                    continue;
                }
                catch (JMSException e) {
                    throw new IllegalHeaderException("Failed to set the JMSDeliveryMode header. Cause: " + e.getLocalizedMessage(), e);
                }
            }
            if (headerName.equalsIgnoreCase(JMS_EXPIRATION)) {
                if (headerValue instanceof Long) {
                    try {
                        jmsMessage.setJMSExpiration(((Long)headerValue).longValue());
                        continue;
                    }
                    catch (JMSException e) {
                        throw new IllegalHeaderException("Failed to set the JMSExpiration header. Cause: " + e.getLocalizedMessage(), e);
                    }
                }
                throw new IllegalHeaderException("The JMSExpiration must be a Long.  Type found: " + headerValue.getClass().getName());
            }
            LOGGER.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
            if (headerName.equalsIgnoreCase(JMS_DESTINATION) || headerName.equalsIgnoreCase(JMS_MESSAGE_ID) || headerName.equalsIgnoreCase(JMS_TIMESTAMP) || headerName.equalsIgnoreCase(JMS_REDELIVERED)) {
                LOGGER.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
                continue;
            }
            if (headerValue instanceof JmsMessageType) continue;
            String encodedName = localKeyFormatStrategy.encodeKey(headerName);
            try {
                JmsMessageHelper.setProperty(jmsMessage, encodedName, headerValue);
            }
            catch (JMSException e) {
                throw new IllegalHeaderException("Failed to set the header " + encodedName + " header. Cause: " + e.getLocalizedMessage(), e);
            }
        }
        return jmsMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setJMSDeliveryMode(Message message, Object deliveryMode) throws JMSException {
        Integer mode = null;
        if (deliveryMode instanceof String) {
            String s = (String)deliveryMode;
            if ("PERSISTENT".equalsIgnoreCase(s)) {
                mode = 2;
            } else if ("NON_PERSISTENT".equalsIgnoreCase(s)) {
                mode = 1;
            } else {
                Integer value = null;
                try {
                    value = Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (value == null) throw new IllegalArgumentException("Unknown delivery mode with value: " + deliveryMode);
                mode = value;
            }
        } else {
            if (!(deliveryMode instanceof Integer)) throw new IllegalArgumentException("Unable to convert the given delivery mode of type " + deliveryMode.getClass().getName() + " with value: " + deliveryMode);
            mode = (Integer)deliveryMode;
        }
        if (mode == null) return;
        message.setJMSDeliveryMode(mode.intValue());
    }

    public static void setMessageType(Message message, String type) {
        block2: {
            try {
                message.setJMSType(type);
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Error setting the message type: {}", (Object)type);
            }
        }
    }

    public static void setCorrelationId(Message message, String correlationId) {
        block2: {
            try {
                message.setJMSCorrelationID(correlationId);
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Error setting the correlationId: {}", (Object)correlationId);
            }
        }
    }

    public static void setProperty(Message jmsMessage, String name, Object value) throws JMSException {
        if (value == null) {
            return;
        }
        if (value instanceof Byte) {
            jmsMessage.setByteProperty(name, ((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            jmsMessage.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            jmsMessage.setDoubleProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            jmsMessage.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            jmsMessage.setIntProperty(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            jmsMessage.setLongProperty(name, ((Long)value).longValue());
        } else if (value instanceof Short) {
            jmsMessage.setShortProperty(name, ((Short)value).shortValue());
        } else if (value instanceof String) {
            jmsMessage.setStringProperty(name, (String)value);
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public static JmsMessageType discoverMessgeTypeFromPayload(Object payload) {
        JmsMessageType answer = null;
        answer = payload == null ? JmsMessageType.Message : (Byte[].class.isInstance(payload) ? JmsMessageType.Bytes : (Collection.class.isInstance(payload) ? JmsMessageType.Map : (InputStream.class.isInstance(payload) ? JmsMessageType.Stream : (String.class.isInstance(payload) ? JmsMessageType.Text : (Serializable.class.isInstance(payload) ? JmsMessageType.Object : JmsMessageType.Message)))));
        return answer;
    }

    public static JmsMessageType discoverJmsMessageType(Message message) {
        JmsMessageType answer = null;
        answer = message != null ? (BytesMessage.class.isInstance(message) ? JmsMessageType.Bytes : (MapMessage.class.isInstance(message) ? JmsMessageType.Map : (TextMessage.class.isInstance(message) ? JmsMessageType.Text : (StreamMessage.class.isInstance(message) ? JmsMessageType.Stream : (ObjectMessage.class.isInstance(message) ? JmsMessageType.Object : JmsMessageType.Message))))) : JmsMessageType.Message;
        return answer;
    }
}

