/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectPool<T> {
    private static final int DEFAULT_POOL_SIZE = 1;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BlockingQueue<T> objects;
    private int maxSize = 1;
    private AtomicInteger poolCount = new AtomicInteger();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ObjectPool() {
        this(1);
    }

    public ObjectPool(int poolSize) {
        this.maxSize = poolSize;
    }

    public void fillPool() {
        this.objects = new ArrayBlockingQueue<T>(this.getMaxSize(), false);
        for (int i = 0; i < this.maxSize; ++i) {
            try {
                T t = this.createObject();
                this.objects.add(t);
                this.poolCount.incrementAndGet();
                continue;
            }
            catch (Exception e) {
                this.logger.error("Unable to create Object and add it to the pool. Reason: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainPool() throws Exception {
        this.getLock().writeLock().lock();
        try {
            while (!this.objects.isEmpty()) {
                Object t = this.objects.remove();
                this.destroyObject(t);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected abstract T createObject() throws Exception;

    protected abstract void destroyObject(T var1) throws Exception;

    public T borrowObject() throws Exception {
        return this.borrowObject(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrowObject(long timeout) throws Exception {
        T t = null;
        this.getLock().writeLock().lock();
        try {
            t = this.objects.poll(timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
        return t;
    }

    public void returnObject(T object) throws Exception {
        this.objects.add(object);
    }

    int size() {
        return this.objects.size();
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

