/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Consumer;
import org.apache.camel.component.aws.s3.S3Producer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Endpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(S3Endpoint.class);
    private AmazonS3 s3Client;
    private S3Configuration configuration;
    private int maxMessagesPerPoll = 10;

    @Deprecated
    public S3Endpoint(String uri, CamelContext context, S3Configuration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public S3Endpoint(String uri, Component comp, S3Configuration configuration) {
        super(uri, comp);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        S3Consumer s3Consumer = new S3Consumer(this, processor);
        this.configureConsumer((Consumer)s3Consumer);
        s3Consumer.setMaxMessagesPerPoll(this.maxMessagesPerPoll);
        return s3Consumer;
    }

    public Producer createProducer() throws Exception {
        return new S3Producer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        String bucketName = this.getConfiguration().getBucketName();
        LOG.trace("Quering whether bucket [{}] already exists...", (Object)bucketName);
        try {
            this.getS3Client().listObjects(new ListObjectsRequest(bucketName, null, null, null, Integer.valueOf(0)));
            LOG.trace("Bucket [{}] already exists", (Object)bucketName);
            return;
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() != 404) {
                throw ase;
            }
            LOG.trace("Bucket [{}] doesn't exist yet", (Object)bucketName);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(this.getConfiguration().getBucketName());
            if (this.getConfiguration().getRegion() != null) {
                createBucketRequest.setRegion(this.getConfiguration().getRegion());
            }
            LOG.trace("Creating bucket [{}] in region [{}] with request [{}]...", new Object[]{this.configuration.getBucketName(), this.configuration.getRegion(), createBucketRequest});
            this.getS3Client().createBucket(createBucketRequest);
            LOG.trace("Bucket created");
            if (this.configuration.getPolicy() != null) {
                LOG.trace("Updating bucket [{}] with policy [{}]", (Object)bucketName, (Object)this.configuration.getPolicy());
                this.getS3Client().setBucketPolicy(bucketName, this.configuration.getPolicy());
                LOG.trace("Bucket policy updated");
            }
            return;
        }
    }

    public Exchange createExchange(S3Object s3Object) {
        return this.createExchange(this.getExchangePattern(), s3Object);
    }

    public Exchange createExchange(ExchangePattern pattern, S3Object s3Object) {
        LOG.trace("Getting object with key [{}] from bucket [{}]...", (Object)s3Object.getKey(), (Object)s3Object.getBucketName());
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        LOG.trace("Got object [{}]", (Object)s3Object);
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        Message message = exchange.getIn();
        message.setBody((Object)s3Object.getObjectContent());
        message.setHeader("CamelAwsS3Key", (Object)s3Object.getKey());
        message.setHeader("CamelAwsS3BucketName", (Object)s3Object.getBucketName());
        message.setHeader("CamelAwsS3ETag", (Object)objectMetadata.getETag());
        message.setHeader("CamelAwsS3LastModified", (Object)objectMetadata.getLastModified());
        message.setHeader("CamelAwsS3VersionId", (Object)objectMetadata.getVersionId());
        message.setHeader("CamelAwsS3ContentType", (Object)objectMetadata.getContentType());
        message.setHeader("CamelAwsS3ContentMD5", (Object)objectMetadata.getContentMD5());
        message.setHeader("CamelAwsS3ContentLength", (Object)objectMetadata.getContentLength());
        message.setHeader("CamelAwsS3ContentEncoding", (Object)objectMetadata.getContentEncoding());
        message.setHeader("CamelAwsS3ContentDisposition", (Object)objectMetadata.getContentDisposition());
        message.setHeader("CamelAwsS3ContentControl", (Object)objectMetadata.getCacheControl());
        return exchange;
    }

    public S3Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(S3Configuration configuration) {
        this.configuration = configuration;
    }

    public void setS3Client(AmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    public AmazonS3 getS3Client() {
        if (this.s3Client == null) {
            this.s3Client = this.configuration.getAmazonS3Client() != null ? this.configuration.getAmazonS3Client() : this.createS3Client();
        }
        return this.s3Client;
    }

    AmazonS3 createS3Client() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AmazonS3Client client = new AmazonS3Client((AWSCredentials)credentials);
        if (this.configuration.getAmazonS3Endpoint() != null) {
            client.setEndpoint(this.configuration.getAmazonS3Endpoint());
        }
        return client;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

