/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.sdb.SdbConfiguration;
import org.apache.camel.component.aws.sdb.SdbEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class SdbComponent
extends DefaultComponent {
    public SdbComponent() {
    }

    public SdbComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SdbConfiguration configuration = new SdbConfiguration();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Domain name must be specified.");
        }
        configuration.setDomainName(remaining);
        if (configuration.getAmazonSDBClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonSDBClient or accessKey and secretKey must be specified");
        }
        SdbEndpoint endpoint = new SdbEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }
}

