/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnsEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SnsEndpoint.class);
    private SnsConfiguration configuration;
    private AmazonSNS snsClient;

    @Deprecated
    public SnsEndpoint(String uri, CamelContext context, SnsConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public SnsEndpoint(String uri, Component component, SnsConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SnsProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        CreateTopicRequest request = new CreateTopicRequest(this.configuration.getTopicName());
        LOG.trace("Creating topic [{}] with request [{}]...", (Object)this.configuration.getTopicName(), (Object)request);
        CreateTopicResult result = this.getSNSClient().createTopic(request);
        this.configuration.setTopicArn(result.getTopicArn());
        LOG.trace("Topic created with Amazon resource name: {}", (Object)this.configuration.getTopicArn());
        if (this.configuration.getPolicy() != null) {
            LOG.trace("Updating topic [{}] with policy [{}]", (Object)this.configuration.getTopicArn(), (Object)this.configuration.getPolicy());
            this.getSNSClient().setTopicAttributes(new SetTopicAttributesRequest(this.configuration.getTopicArn(), "Policy", this.configuration.getPolicy()));
            LOG.trace("Topic policy updated");
        }
    }

    public SnsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SnsConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setSNSClient(AmazonSNS snsClient) {
        this.snsClient = snsClient;
    }

    public AmazonSNS getSNSClient() {
        if (this.snsClient == null) {
            this.snsClient = this.configuration.getAmazonSNSClient() != null ? this.configuration.getAmazonSNSClient() : this.createSNSClient();
        }
        return this.snsClient;
    }

    AmazonSNS createSNSClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AmazonSNSClient client = new AmazonSNSClient((AWSCredentials)credentials);
        if (this.configuration.getAmazonSNSEndpoint() != null) {
            client.setEndpoint(this.configuration.getAmazonSNSEndpoint());
        }
        return client;
    }
}

