/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.net.URI;
import java.util.Map;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cache.CacheEventListenerRegistry;
import org.apache.camel.component.cache.CacheLoaderRegistry;
import org.apache.camel.util.URISupport;

public class CacheConfiguration
implements Cloneable {
    private String cacheName;
    private int maxElementsInMemory = 1000;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LFU;
    private boolean overflowToDisk = true;
    private String diskStorePath;
    private boolean eternal;
    private long timeToLiveSeconds = 300L;
    private long timeToIdleSeconds = 300L;
    private boolean diskPersistent;
    private long diskExpiryThreadIntervalSeconds;
    private CacheEventListenerRegistry eventListenerRegistry = new CacheEventListenerRegistry();
    private CacheLoaderRegistry cacheLoaderRegistry = new CacheLoaderRegistry();

    public CacheConfiguration() {
    }

    public CacheConfiguration(URI uri) throws Exception {
        this.parseURI(uri);
    }

    public CacheConfiguration copy() {
        try {
            CacheConfiguration copy = (CacheConfiguration)this.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void parseURI(URI uri) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("cache")) {
            throw new IllegalArgumentException("Unrecognized Cache protocol: " + protocol + " for uri: " + uri);
        }
        this.setCacheName(uri.getHost());
        Map cacheSettings = URISupport.parseParameters((URI)uri);
        if (cacheSettings.containsKey("maxElementsInMemory")) {
            this.setMaxElementsInMemory(Integer.valueOf((String)cacheSettings.get("maxElementsInMemory")));
        }
        if (cacheSettings.containsKey("overflowToDisk")) {
            this.setOverflowToDisk(Boolean.valueOf((String)cacheSettings.get("overflowToDisk")));
        }
        if (cacheSettings.containsKey("diskStorePath")) {
            this.setDiskStorePath((String)cacheSettings.get("diskStorePath"));
        }
        if (cacheSettings.containsKey("eternal")) {
            this.setEternal(Boolean.valueOf((String)cacheSettings.get("eternal")));
        }
        if (cacheSettings.containsKey("timeToLiveSeconds")) {
            this.setTimeToLiveSeconds(Long.valueOf((String)cacheSettings.get("timeToLiveSeconds")));
        }
        if (cacheSettings.containsKey("timeToIdleSeconds")) {
            this.setTimeToIdleSeconds(Long.valueOf((String)cacheSettings.get("timeToIdleSeconds")));
        }
        if (cacheSettings.containsKey("diskPersistent")) {
            this.setDiskPersistent(Boolean.valueOf((String)cacheSettings.get("diskPersistent")));
        }
        if (cacheSettings.containsKey("diskExpiryThreadIntervalSeconds")) {
            this.setDiskExpiryThreadIntervalSeconds(Long.valueOf((String)cacheSettings.get("diskExpiryThreadIntervalSeconds")));
        }
        if (cacheSettings.containsKey("memoryStoreEvictionPolicy")) {
            String policy = (String)cacheSettings.get("memoryStoreEvictionPolicy");
            policy = policy.replace("MemoryStoreEvictionPolicy.", "");
            this.setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.fromString((String)policy));
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setEventListenerRegistry(CacheEventListenerRegistry eventListenerRegistry) {
        this.eventListenerRegistry = eventListenerRegistry;
    }

    public CacheEventListenerRegistry getEventListenerRegistry() {
        return this.eventListenerRegistry;
    }

    public void setCacheLoaderRegistry(CacheLoaderRegistry cacheLoaderRegistry) {
        this.cacheLoaderRegistry = cacheLoaderRegistry;
    }

    public CacheLoaderRegistry getCacheLoaderRegistry() {
        return this.cacheLoaderRegistry;
    }
}

