/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.Serializable;
import java.util.Map;
import org.apache.camel.CamelException;

public class RestletOperationException
extends CamelException
implements Serializable {
    private static final long serialVersionUID = -1696222841120185992L;
    private final String uri;
    private final String redirectLocation;
    private final int statusCode;
    private final String statusText;
    private final Map<String, String> responseHeaders;
    private final String responseBody;

    public RestletOperationException(String uri, int statusCode, String statusText, String location, Map<String, String> responseHeaders, String responseBody) {
        super("Restlet operation failed invoking " + uri + " with statusCode: " + statusCode + (location != null ? ", redirectLocation: " + location : " /n responseBody:" + responseBody));
        this.uri = uri;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.redirectLocation = location;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getUri() {
        return this.uri;
    }
}

