/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQComponent.class);

    public RabbitMQComponent() {
    }

    public RabbitMQComponent(CamelContext context) {
        super(context);
    }

    protected RabbitMQEndpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        URI host = new URI("http://" + remaining);
        String hostname = host.getHost();
        int portNumber = host.getPort();
        String exchangeName = host.getPath().substring(1);
        RabbitMQEndpoint endpoint = new RabbitMQEndpoint(uri, this);
        endpoint.setHostname(hostname);
        endpoint.setPortNumber(portNumber);
        endpoint.setExchangeName(exchangeName);
        this.setProperties((Object)endpoint, params);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RabbitMQEndpoint with host {}:{} and exchangeName: {}", new Object[]{endpoint.getHostname(), endpoint.getPortNumber(), endpoint.getExchangeName()});
        }
        return endpoint;
    }
}

