/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SolrComponent.class);
    private final Map<SolrEndpoint, SolrServerReference> servers = new HashMap<SolrEndpoint, SolrServerReference>();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SolrEndpoint endpoint = new SolrEndpoint(uri, this, remaining);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public SolrServerReference getSolrServers(SolrEndpoint endpoint) {
        return this.servers.get((Object)endpoint);
    }

    public void addSolrServers(SolrEndpoint endpoint, SolrServerReference servers) {
        this.servers.put(endpoint, servers);
    }

    protected void doShutdown() throws Exception {
        for (SolrServerReference server : this.servers.values()) {
            this.shutdownServers(server);
        }
        this.servers.clear();
    }

    void shutdownServers(SolrServerReference ref) {
        this.shutdownServers(ref, false);
    }

    void shutdownServers(SolrServerReference ref, boolean remove) {
        try {
            if (ref.getSolrServer() != null) {
                LOG.info("Shutting down solr server: {}", (Object)ref.getSolrServer());
                ref.getSolrServer().shutdown();
            }
        }
        catch (Exception e) {
            LOG.warn("Error shutting down solr server. This exception is ignored.", (Throwable)e);
        }
        try {
            if (ref.getUpdateSolrServer() != null) {
                LOG.info("Shutting down update solr server: {}", (Object)ref.getUpdateSolrServer());
                ref.getUpdateSolrServer().shutdownNow();
            }
        }
        catch (Exception e) {
            LOG.warn("Error shutting down streaming solr server. This exception is ignored.", (Throwable)e);
        }
        if (remove) {
            SolrEndpoint key = null;
            for (Map.Entry<SolrEndpoint, SolrServerReference> entry : this.servers.entrySet()) {
                if (entry.getValue() != ref) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                this.servers.remove((Object)key);
            }
        }
    }

    protected static final class SolrServerReference {
        private final AtomicInteger referenceCounter = new AtomicInteger();
        private HttpSolrServer solrServer;
        private ConcurrentUpdateSolrServer updateSolrServer;

        protected SolrServerReference() {
        }

        public HttpSolrServer getSolrServer() {
            return this.solrServer;
        }

        public void setSolrServer(HttpSolrServer solrServer) {
            this.solrServer = solrServer;
        }

        public ConcurrentUpdateSolrServer getUpdateSolrServer() {
            return this.updateSolrServer;
        }

        public void setUpdateSolrServer(ConcurrentUpdateSolrServer updateSolrServer) {
            this.updateSolrServer = updateSolrServer;
        }

        public int addReference() {
            return this.referenceCounter.incrementAndGet();
        }

        public int decReference() {
            return this.referenceCounter.decrementAndGet();
        }
    }
}

