/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.net.URL;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class SolrEndpoint
extends DefaultEndpoint {
    private String requestHandler;
    private String url;
    private int streamingQueueSize = 10;
    private int streamingThreadCount = 2;
    private Integer maxRetries;
    private Integer soTimeout;
    private Integer connectionTimeout;
    private Integer defaultMaxConnectionsPerHost;
    private Integer maxTotalConnections;
    private Boolean followRedirects;
    private Boolean allowCompression;

    public SolrEndpoint(String endpointUri, SolrComponent component, String address) throws Exception {
        super(endpointUri, (Component)component);
        URL url = new URL("http://" + address);
        this.url = url.toString();
    }

    public SolrComponent getComponent() {
        return (SolrComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        SolrComponent.SolrServerReference ref = this.getComponent().getSolrServers(this);
        if (ref == null) {
            HttpSolrServer solrServer = new HttpSolrServer(this.url);
            ConcurrentUpdateSolrServer solrStreamingServer = new ConcurrentUpdateSolrServer(this.url, this.streamingQueueSize, this.streamingThreadCount);
            if (this.maxRetries != null) {
                solrServer.setMaxRetries(this.maxRetries.intValue());
            }
            if (this.soTimeout != null) {
                solrServer.setSoTimeout(this.soTimeout.intValue());
            }
            if (this.connectionTimeout != null) {
                solrServer.setConnectionTimeout(this.connectionTimeout.intValue());
            }
            if (this.defaultMaxConnectionsPerHost != null) {
                solrServer.setDefaultMaxConnectionsPerHost(this.defaultMaxConnectionsPerHost.intValue());
            }
            if (this.maxTotalConnections != null) {
                solrServer.setMaxTotalConnections(this.maxTotalConnections.intValue());
            }
            if (this.followRedirects != null) {
                solrServer.setFollowRedirects(this.followRedirects.booleanValue());
            }
            if (this.allowCompression != null) {
                solrServer.setAllowCompression(this.allowCompression.booleanValue());
            }
            ref = new SolrComponent.SolrServerReference();
            ref.setSolrServer(solrServer);
            ref.setUpdateSolrServer(solrStreamingServer);
            this.getComponent().addSolrServers(this, ref);
        }
        ref.addReference();
        return new SolrProducer(this, ref.getSolrServer(), ref.getUpdateSolrServer());
    }

    protected void onProducerShutdown(SolrProducer producer) {
        int counter;
        SolrComponent.SolrServerReference ref = this.getComponent().getSolrServers(this);
        if (ref != null && (counter = ref.decReference()) <= 0) {
            this.getComponent().shutdownServers(ref, true);
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Solr endpoint.");
    }

    public boolean isSingleton() {
        return true;
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public int getStreamingThreadCount() {
        return this.streamingThreadCount;
    }

    public void setStreamingThreadCount(int streamingThreadCount) {
        this.streamingThreadCount = streamingThreadCount;
    }

    public int getStreamingQueueSize() {
        return this.streamingQueueSize;
    }

    public void setStreamingQueueSize(int streamingQueueSize) {
        this.streamingQueueSize = streamingQueueSize;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getDefaultMaxConnectionsPerHost() {
        return this.defaultMaxConnectionsPerHost;
    }

    public void setDefaultMaxConnectionsPerHost(Integer defaultMaxConnectionsPerHost) {
        this.defaultMaxConnectionsPerHost = defaultMaxConnectionsPerHost;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public Boolean getAllowCompression() {
        return this.allowCompression;
    }

    public void setAllowCompression(Boolean allowCompression) {
        this.allowCompression = allowCompression;
    }
}

