/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.File;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;

public class SolrProducer
extends DefaultProducer {
    private HttpSolrServer solrServer;
    private ConcurrentUpdateSolrServer streamingSolrServer;

    public SolrProducer(SolrEndpoint endpoint, HttpSolrServer solrServer, ConcurrentUpdateSolrServer streamingSolrServer) {
        super((Endpoint)endpoint);
        this.solrServer = solrServer;
        this.streamingSolrServer = streamingSolrServer;
    }

    public void process(Exchange exchange) throws Exception {
        String operation = (String)exchange.getIn().getHeader("SolrOperation");
        if (operation == null) {
            throw new IllegalArgumentException("SolrOperation header is missing");
        }
        if (operation.equalsIgnoreCase("INSERT")) {
            this.insert(exchange, false);
        } else if (operation.equalsIgnoreCase("INSERT_STREAMING")) {
            this.insert(exchange, true);
        } else if (operation.equalsIgnoreCase("DELETE_BY_ID")) {
            this.solrServer.deleteById((String)exchange.getIn().getBody(String.class));
        } else if (operation.equalsIgnoreCase("DELETE_BY_QUERY")) {
            this.solrServer.deleteByQuery((String)exchange.getIn().getBody(String.class));
        } else if (operation.equalsIgnoreCase("ADD_BEAN")) {
            this.solrServer.addBean(exchange.getIn().getBody());
        } else if (operation.equalsIgnoreCase("COMMIT")) {
            this.solrServer.commit();
        } else if (operation.equalsIgnoreCase("ROLLBACK")) {
            this.solrServer.rollback();
        } else if (operation.equalsIgnoreCase("OPTIMIZE")) {
            this.solrServer.optimize();
        } else {
            throw new IllegalArgumentException("SolrOperation header value '" + operation + "' is not supported");
        }
    }

    private void insert(Exchange exchange, boolean isStreaming) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof File) {
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler());
            updateRequest.addFile((File)body);
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
                String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
                updateRequest.setParam(paramName, entry.getValue().toString());
            }
            if (isStreaming) {
                updateRequest.process((SolrServer)this.streamingSolrServer);
            } else {
                updateRequest.process((SolrServer)this.solrServer);
            }
        } else if (body instanceof SolrInputDocument) {
            UpdateRequest updateRequest = new UpdateRequest(this.getRequestHandler());
            updateRequest.add((SolrInputDocument)body);
            if (isStreaming) {
                updateRequest.process((SolrServer)this.streamingSolrServer);
            } else {
                updateRequest.process((SolrServer)this.solrServer);
            }
        } else {
            boolean hasSolrHeaders = false;
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                hasSolrHeaders = true;
                break;
            }
            if (hasSolrHeaders) {
                UpdateRequest updateRequest = new UpdateRequest(this.getRequestHandler());
                SolrInputDocument doc = new SolrInputDocument();
                for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                    String fieldName = ((String)entry.getKey()).substring("SolrField.".length());
                    doc.setField(fieldName, entry.getValue());
                }
                updateRequest.add(doc);
                if (isStreaming) {
                    updateRequest.process((SolrServer)this.streamingSolrServer);
                } else {
                    updateRequest.process((SolrServer)this.solrServer);
                }
            } else if (body instanceof String) {
                String bodyAsString = (String)body;
                if (!bodyAsString.startsWith("<add")) {
                    bodyAsString = "<add>" + bodyAsString + "</add>";
                }
                DirectXmlRequest xmlRequest = new DirectXmlRequest(this.getRequestHandler(), bodyAsString);
                if (isStreaming) {
                    this.streamingSolrServer.request((SolrRequest)xmlRequest);
                } else {
                    this.solrServer.request((SolrRequest)xmlRequest);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unable to find data in Exchange to update Solr");
            }
        }
    }

    private String getRequestHandler() {
        String requestHandler = this.getEndpoint().getRequestHandler();
        return requestHandler == null ? "/update" : requestHandler;
    }

    public SolrEndpoint getEndpoint() {
        return (SolrEndpoint)super.getEndpoint();
    }

    protected void doShutdown() throws Exception {
        this.getEndpoint().onProducerShutdown(this);
    }
}

