/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.validator.BeanValidationException;

public class BeanValidator
implements Processor {
    private ValidatorFactory validatorFactory;
    private Validator validator;
    private Class<?> group;

    public void process(Exchange exchange) throws Exception {
        Object bean = exchange.getIn().getBody();
        Set constraintViolations = null;
        constraintViolations = this.group != null ? this.validator.validate(bean, new Class[]{this.group}) : this.validator.validate(bean, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new BeanValidationException(exchange, constraintViolations, exchange.getIn().getBody());
        }
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
        this.validator = this.validatorFactory.getValidator();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public Class<?> getGroup() {
        return this.group;
    }

    public void setGroup(Class<?> group) {
        this.group = group;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.validatorFactory.getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.validatorFactory.getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validatorFactory.getConstraintValidatorFactory();
    }
}

