/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator;

import java.util.Map;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.validator.BeanValidator;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;

public class BeanValidatorComponent
extends DefaultComponent {
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BeanValidator beanValidator = new BeanValidator();
        MessageInterpolator messageInterpolator = (MessageInterpolator)this.resolveAndRemoveReferenceParameter(parameters, "messageInterpolator", MessageInterpolator.class);
        TraversableResolver traversableResolver = (TraversableResolver)this.resolveAndRemoveReferenceParameter(parameters, "traversableResolver", TraversableResolver.class);
        ConstraintValidatorFactory constraintValidatorFactory = (ConstraintValidatorFactory)this.resolveAndRemoveReferenceParameter(parameters, "constraintValidatorFactory", ConstraintValidatorFactory.class);
        String group = (String)this.getAndRemoveParameter(parameters, "group", String.class);
        Configuration configuration = Validation.byDefaultProvider().configure();
        if (messageInterpolator != null) {
            configuration.messageInterpolator(messageInterpolator);
        }
        if (traversableResolver != null) {
            configuration.traversableResolver(traversableResolver);
        }
        if (constraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(constraintValidatorFactory);
        }
        ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
        beanValidator.setValidatorFactory(validatorFactory);
        if (group != null) {
            beanValidator.setGroup(this.getCamelContext().getClassResolver().resolveMandatoryClass(group));
        }
        return new ProcessorEndpoint(uri, (Component)this, (Processor)beanValidator);
    }
}

