/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestSupportJmxCleanup {
    private static final Logger LOG = LoggerFactory.getLogger(TestSupportJmxCleanup.class);

    private TestSupportJmxCleanup() {
    }

    public static void removeMBeans(String domain) throws Exception {
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> s = mbsc.queryNames(new ObjectName(TestSupportJmxCleanup.getDomainName(domain) + ":*"), null);
        for (ObjectName on : s) {
            mbsc.unregisterMBean(on);
        }
    }

    public static void traceMBeans(String domain) throws Exception {
        String d;
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> s = mbsc.queryNames(new ObjectName((d = TestSupportJmxCleanup.getDomainName(domain)) + ":*"), null);
        if (s.size() > 0) {
            LOG.warn(" + " + s.size() + " ObjectNames registered in domain \"" + d + "\"");
            for (ObjectName on : s) {
                LOG.warn(" |  " + on);
            }
        }
    }

    private static String getDomainName(String domain) {
        return domain == null ? "org.apache.camel" : domain;
    }
}

