/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.LoggingErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.SendProcessor;

public class ContextErrorHandlerTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        this.setUseRouteBuilder(false);
        super.setUp();
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.maximumRedeliveries(1);
        redeliveryPolicy.setUseExponentialBackOff(true);
        DeadLetterChannelBuilder deadLetterChannelBuilder = new DeadLetterChannelBuilder("mock:error");
        deadLetterChannelBuilder.setRedeliveryPolicy(redeliveryPolicy);
        this.context.setErrorHandlerBuilder((ErrorHandlerFactory)deadLetterChannelBuilder);
    }

    @Override
    protected void startCamelContext() throws Exception {
    }

    @Override
    protected void stopCamelContext() throws Exception {
    }

    protected List<Route> getRouteListWithCurrentContext(RouteBuilder builder) throws Exception {
        this.context.addRoutes((RoutesBuilder)builder);
        this.context.start();
        List answer = this.context.getRoutes();
        this.context.stop();
        return answer;
    }

    public void testOverloadingTheDefaultErrorHandler() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler("FOO.BAR"));
                this.from("seda:a").to("seda:b");
            }
        };
        List<Route> list = this.getRouteListWithCurrentContext(builder);
        ContextErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)1, (int)list.size());
        for (Route route : list) {
            Endpoint key = route.getEndpoint();
            ContextErrorHandlerTest.assertEquals((String)"From endpoint", (String)"seda://a", (String)key.getEndpointUri());
            EventDrivenConsumerRoute consumerRoute = ContextErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            Channel channel = ContextErrorHandlerTest.unwrapChannel(processor);
            ContextErrorHandlerTest.assertIsInstanceOf(LoggingErrorHandler.class, channel.getErrorHandler());
            SendProcessor sendProcessor = ContextErrorHandlerTest.assertIsInstanceOf(SendProcessor.class, channel.getNextProcessor());
            this.log.debug("Found sendProcessor: " + sendProcessor);
        }
    }

    public void testGetTheDefaultErrorHandlerFromContext() throws Exception {
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.from("seda:a").to("seda:b");
                this.from("direct:c").to("direct:d");
            }
        };
        List<Route> list = this.getRouteListWithCurrentContext(builder);
        ContextErrorHandlerTest.assertEquals((String)("Number routes created" + list), (int)2, (int)list.size());
        for (Route route : list) {
            EventDrivenConsumerRoute consumerRoute = ContextErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
            Processor processor = consumerRoute.getProcessor();
            Channel channel = ContextErrorHandlerTest.unwrapChannel(processor);
            DeadLetterChannel deadLetterChannel = ContextErrorHandlerTest.assertIsInstanceOf(DeadLetterChannel.class, channel.getErrorHandler());
            RedeliveryPolicy redeliveryPolicy = deadLetterChannel.getRedeliveryPolicy();
            ContextErrorHandlerTest.assertEquals((String)"getMaximumRedeliveries()", (int)1, (int)redeliveryPolicy.getMaximumRedeliveries());
            ContextErrorHandlerTest.assertEquals((String)"isUseExponentialBackOff()", (boolean)true, (boolean)redeliveryPolicy.isUseExponentialBackOff());
        }
    }
}

