/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;

public class ExpressionClauseTest
extends ContextTestSupport {
    public void testConstant() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodyReceived().constant((Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAttachments() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"log4j.properties", "jndi-example.properties"});
        this.template.send("direct:begin", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message m = exchange.getIn();
                m.setBody((Object)"Hello World");
                m.addAttachment("log4j", new DataHandler((DataSource)new FileDataSource("src/test/resources/log4j.properties")));
                m.addAttachment("jndi-example", new DataHandler((DataSource)new FileDataSource("src/test/resources/jndi-example.properties")));
            }
        });
        this.assertMockEndpointsSatisfied();
        Map attachments = ((Exchange)mock.getExchanges().get(0)).getIn().getAttachments();
        ExpressionClauseTest.assertTrue((attachments == null || attachments.size() == 0 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
                ((ExpressionNode)((SplitDefinition)this.from("direct:begin").split().attachments()).bean((Object)new Extractor())).to("mock:result");
            }
        };
    }

    public final class Extractor {
        public String extractName(DataHandler body) {
            DataSource ds;
            DataSource dataSource = ds = body != null ? body.getDataSource() : null;
            if (ds != null && ds instanceof FileDataSource) {
                return ((FileDataSource)ds).getName();
            }
            return null;
        }
    }
}

