/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.impl.JndiRegistry;

public class ThreadPoolBuilderTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        ExecutorService someone = Executors.newCachedThreadPool();
        jndi.bind("someonesPool", (Object)someone);
        return jndi;
    }

    public void testThreadPoolBuilderDefault() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderMaxQueueSize() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.maxQueueSize(2000).build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderMax() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.maxPoolSize(100).build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderCoreAndMax() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.poolSize(50).maxPoolSize(100).build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderKeepAlive() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.keepAliveTime(30L).build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderKeepAliveTimeUnit() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.keepAliveTime(20000L, TimeUnit.MILLISECONDS).build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderAll() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.poolSize(50).maxPoolSize(100).maxQueueSize(2000).keepAliveTime(20000L, TimeUnit.MILLISECONDS).rejectedPolicy(ThreadPoolRejectedPolicy.DiscardOldest).build((Object)this, "myPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderTwoPoolsDefault() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.build((Object)this, "myPool");
        ExecutorService executor2 = builder.build((Object)this, "myOtherPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertNotNull((Object)executor2);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor2.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor2.isShutdown());
    }

    public void testThreadPoolBuilderScheduled() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ScheduledExecutorService executor = builder.poolSize(5).maxQueueSize(2000).buildScheduled();
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderScheduledName() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ScheduledExecutorService executor = builder.poolSize(5).maxQueueSize(2000).buildScheduled("myScheduledPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }

    public void testThreadPoolBuilderScheduledSourceName() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ScheduledExecutorService executor = builder.poolSize(5).maxQueueSize(2000).buildScheduled((Object)this, "myScheduledPool");
        ThreadPoolBuilderTest.assertNotNull((Object)executor);
        ThreadPoolBuilderTest.assertEquals((boolean)false, (boolean)executor.isShutdown());
        this.context.stop();
        ThreadPoolBuilderTest.assertEquals((boolean)true, (boolean)executor.isShutdown());
    }
}

