/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.XPathBuilder;

public class DefaultNamespaceContextTest
extends ContextTestSupport {
    public void testDefaultNamespaceContextEmpty() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        DefaultNamespaceContextTest.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("foo");
        DefaultNamespaceContextTest.assertNull((Object)uri);
        String prefix = context.getPrefix("foo");
        DefaultNamespaceContextTest.assertNull((Object)prefix);
        Iterator it = context.getPrefixes("foo");
        DefaultNamespaceContextTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testDefaultNamespaceContextPre() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo").namespace("pre", "http://acme/cheese");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        DefaultNamespaceContextTest.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("pre");
        DefaultNamespaceContextTest.assertEquals((String)"http://acme/cheese", (String)uri);
        String prefix = context.getPrefix("http://acme/cheese");
        DefaultNamespaceContextTest.assertEquals((String)"pre", (String)prefix);
        Iterator it = context.getPrefixes("http://acme/cheese");
        DefaultNamespaceContextTest.assertEquals((boolean)true, (boolean)it.hasNext());
        DefaultNamespaceContextTest.assertEquals((String)"pre", (String)((String)it.next()));
    }

    public void testDefaultNamespaceContextDualNamespaces() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo").namespace("pre", "http://acme/cheese").namespace("bar", "http://acme/bar");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        DefaultNamespaceContextTest.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("pre");
        DefaultNamespaceContextTest.assertEquals((String)"http://acme/cheese", (String)uri);
        String uri2 = context.getNamespaceURI("bar");
        DefaultNamespaceContextTest.assertEquals((String)"http://acme/bar", (String)uri2);
        String prefix = context.getPrefix("http://acme/cheese");
        DefaultNamespaceContextTest.assertEquals((String)"pre", (String)prefix);
        String prefix2 = context.getPrefix("http://acme/bar");
        DefaultNamespaceContextTest.assertEquals((String)"bar", (String)prefix2);
        Iterator it = context.getPrefixes("http://acme/cheese");
        DefaultNamespaceContextTest.assertEquals((boolean)true, (boolean)it.hasNext());
        DefaultNamespaceContextTest.assertEquals((String)"pre", (String)((String)it.next()));
        Iterator it2 = context.getPrefixes("http://acme/bar");
        DefaultNamespaceContextTest.assertEquals((boolean)true, (boolean)it2.hasNext());
        DefaultNamespaceContextTest.assertEquals((String)"bar", (String)((String)it2.next()));
    }

    public void testDefaultNamespaceContextParent() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        DefaultNamespaceContextTest.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("in");
        DefaultNamespaceContextTest.assertEquals((String)"http://camel.apache.org/xml/in/", (String)uri);
        String prefix = context.getPrefix("http://camel.apache.org/xml/in/");
        DefaultNamespaceContextTest.assertEquals((String)"in", (String)prefix);
        Iterator it = context.getPrefixes("http://camel.apache.org/xml/in/");
        DefaultNamespaceContextTest.assertEquals((boolean)true, (boolean)it.hasNext());
        DefaultNamespaceContextTest.assertEquals((String)"in", (String)((String)it.next()));
        String uri2 = context.getNamespaceURI("out");
        DefaultNamespaceContextTest.assertEquals((String)"http://camel.apache.org/xml/out/", (String)uri2);
        String uri3 = context.getNamespaceURI("env");
        DefaultNamespaceContextTest.assertEquals((String)"http://camel.apache.org/xml/variables/environment-variables", (String)uri3);
        String uri4 = context.getNamespaceURI("system");
        DefaultNamespaceContextTest.assertEquals((String)"http://camel.apache.org/xml/variables/system-properties", (String)uri4);
    }

    public void testDefaultNamespaceContextCtr() throws Exception {
        DefaultNamespaceContext context = new DefaultNamespaceContext();
        String uri = context.getNamespaceURI("in");
        DefaultNamespaceContextTest.assertEquals(null, (String)uri);
    }

    public void testDefaultNamespaceContextAnotherCtr() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "http://acme/cheese");
        DefaultNamespaceContext context = new DefaultNamespaceContext(null, map);
        String uri = context.getNamespaceURI("in");
        DefaultNamespaceContextTest.assertEquals(null, (String)uri);
        String uri2 = context.getNamespaceURI("foo");
        DefaultNamespaceContextTest.assertEquals((String)"http://acme/cheese", (String)uri2);
    }
}

