/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.xml.InvalidXPathExpression;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testXPathExpressions() throws Exception {
        this.assertExpression("/foo/bar/@xyz", "<foo><bar xyz='cheese'/></foo>", "cheese");
        this.assertExpression("$name", "<foo><bar xyz='cheese'/></foo>", "James");
        this.assertExpression("foo/bar", "<foo><bar>cheese</bar></foo>", "cheese");
        this.assertExpression("foo/bar/text()", "<foo><bar>cheese</bar></foo>", "cheese");
        this.assertExpression("/foo/@id", "<foo id='cheese'>hey</foo>", "cheese");
        this.assertExpression("/foo/@num", "<foo num='123'>hey</foo>", "123");
    }

    public void testXPathPredicates() throws Exception {
        this.assertPredicate("/foo/bar/@xyz", "<foo><bar xyz='cheese'/></foo>", true);
        this.assertPredicate("$name = 'James'", "<foo><bar xyz='cheese'/></foo>", true);
        this.assertPredicate("$name = 'Hiram'", "<foo><bar xyz='cheese'/></foo>", false);
        this.assertPredicate("/foo/notExist", "<foo><bar xyz='cheese'/></foo>", false);
        this.assertPredicate("/foo[@num = '123']", "<foo num='123'>hey</foo>", true);
    }

    public void testXPathWithCustomVariable() throws Exception {
        this.assertExpression((Expression)XPathBuilder.xpath((String)"$name").stringResult().variable("name", (Object)"Hiram"), "<foo/>", "Hiram");
    }

    public void testInvalidXPath() throws Exception {
        try {
            this.assertPredicate("/foo/", "<foo><bar xyz='cheese'/></foo>", true);
            XPathTest.fail((String)"Should have thrown exception");
        }
        catch (InvalidXPathExpression e) {
            XPathTest.assertEquals((String)"/foo/", (String)e.getXpath());
            XPathTest.assertIsInstanceOf(XPathExpressionException.class, e.getCause());
        }
    }

    public void testXPathBooleanResult() throws Exception {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").booleanResult().evaluate(this.createExchange("<foo><bar xyz='cheese'/></foo>"));
        Boolean bool = XPathTest.assertIsInstanceOf(Boolean.class, result);
        XPathTest.assertEquals((boolean)true, (boolean)bool);
    }

    public void testXPathNodeResult() throws Exception {
        Object result = XPathBuilder.xpath((String)"/foo/bar").nodeResult().evaluate(this.createExchange("<foo><bar xyz='cheese'/></foo>"));
        Node node = XPathTest.assertIsInstanceOf(Node.class, result);
        XPathTest.assertNotNull((Object)node);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)node);
        XPathTest.assertEquals((String)"<bar xyz=\"cheese\"/>", (String)s);
    }

    public void testXPathNodeSetResult() throws Exception {
        Object result = XPathBuilder.xpath((String)"/foo").nodeSetResult().evaluate(this.createExchange("<foo>bar</foo>"));
        NodeList node = XPathTest.assertIsInstanceOf(NodeList.class, result);
        XPathTest.assertNotNull((Object)node);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)node);
        XPathTest.assertEquals((String)"<foo>bar</foo>", (String)s);
    }

    public void testXPathNumberResult() throws Exception {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").numberResult().evaluate(this.createExchange("<foo><bar xyz='123'/></foo>"));
        Double num = XPathTest.assertIsInstanceOf(Double.class, result);
        XPathTest.assertEquals((String)"123.0", (String)num.toString());
    }

    public void testXPathStringResult() throws Exception {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").stringResult().evaluate(this.createExchange("<foo><bar xyz='123'/></foo>"));
        String num = XPathTest.assertIsInstanceOf(String.class, result);
        XPathTest.assertEquals((String)"123", (String)num);
    }

    public void testXPathCustomResult() throws Exception {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").resultType(Integer.class).evaluate(this.createExchange("<foo><bar xyz='123'/></foo>"));
        Integer num = XPathTest.assertIsInstanceOf(Integer.class, result);
        XPathTest.assertEquals((int)123, (int)num);
    }

    public void testXPathBuilder() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo/bar");
        XPathTest.assertEquals((String)"/foo/bar", (String)builder.getText());
        XPathTest.assertEquals((Object)XPathConstants.NODESET, (Object)builder.getResultQName());
        XPathTest.assertNull((Object)builder.getResultType());
    }

    public void testXPathWithDocument() throws Exception {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Object result = XPathBuilder.xpath((String)"/foo").evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"<foo>bar</foo>", (String)s);
    }

    public void testXPathWithDocumentTypeDOMSource() throws Exception {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(DOMSource.class);
        Object result = builder.evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"<foo>bar</foo>", (String)s);
    }

    public void testXPathWithDocumentTypeInputSource() throws Exception {
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputSource doc = new InputSource(is);
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(InputSource.class);
        Object result = builder.evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"<foo>bar</foo>", (String)s);
    }

    public void testXPathWithDocumentTypeInputSourceFluentBuilder() throws Exception {
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputSource doc = new InputSource(is);
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo").documentType(InputSource.class);
        Object result = builder.evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"<foo>bar</foo>", (String)s);
    }

    public void testXPathWithDocumentTypeInputSourceNoResultQName() throws Exception {
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputSource doc = new InputSource(is);
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(InputSource.class);
        builder.setResultQName(null);
        Object result = builder.evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"bar", (String)s);
    }

    public void testXPathWithDocumentTypeDOMSourceNoResultQName() throws Exception {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(DOMSource.class);
        builder.setResultQName(null);
        Object result = builder.evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"bar", (String)s);
    }

    public void testXPathWithStringTypeDOMSourceNoResultQName() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setResultQName(null);
        Object result = builder.evaluate(this.createExchange("<foo>bar</foo>"));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"bar", (String)s);
    }

    public void testXPathWithNamespaceBooleanResult() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person[@name='James']").namespace("c", "http://acme.com/cheese").booleanResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        XPathTest.assertNotNull((Object)result);
        XPathTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testXPathWithNamespaceBooleanResultType() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person[@name='James']").namespace("c", "http://acme.com/cheese");
        builder.setResultType(Boolean.class);
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        XPathTest.assertNotNull((Object)result);
        XPathTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testXPathWithNamespaceStringResult() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person/@name").namespace("c", "http://acme.com/cheese").stringResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        XPathTest.assertNotNull((Object)result);
        XPathTest.assertEquals((Object)"James", (Object)result);
    }

    public void testXPathWithNamespacesBooleanResult() throws Exception {
        Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person[@name='James']").namespaces(ns).booleanResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        XPathTest.assertNotNull((Object)result);
        XPathTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public void testXPathWithNamespacesStringResult() throws Exception {
        Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person/@name").namespaces(ns).stringResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        XPathTest.assertNotNull((Object)result);
        XPathTest.assertEquals((Object)"James", (Object)result);
    }

    public void testXPathWithNamespacesNodeResult() throws Exception {
        Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person/@name").namespaces(ns);
        builder.setResultType(Node.class);
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        XPathTest.assertNotNull((Object)result);
        XPathTest.assertTrue((boolean)result.toString().contains("James"));
    }

    public void testUsingJavaExtensions() throws Exception {
        try {
            Object instance = Class.forName("org.apache.xalan.extensions.XPathFunctionResolverImpl").newInstance();
            if (instance instanceof XPathFunctionResolver) {
                XPathFunctionResolver functionResolver = (XPathFunctionResolver)instance;
                XPathBuilder builder = XPathBuilder.xpath((String)("java:" + ((Object)((Object)this)).getClass().getName() + ".func(string(/header/value))")).namespace("java", "http://xml.apache.org/xalan/java").functionResolver(functionResolver);
                String xml = "<header><value>12</value></header>";
                Object value = this.assertExpression((Expression)builder, xml, "modified12");
                this.log.debug("Evaluated xpath: " + builder.getText() + " on XML: " + xml + " result: " + value);
            }
        }
        catch (Throwable e) {
            this.log.debug("Could not find Xalan on the classpath so ignoring this test case: " + e);
        }
    }

    protected Object assertExpression(String xpath, String xml, String expected) {
        XPathBuilder expression = XPathBuilder.xpath((String)xpath).stringResult();
        return this.assertExpression((Expression)expression, xml, expected);
    }

    protected Object assertExpression(Expression expression, String xml, String expected) {
        return XPathTest.assertExpression(expression, this.createExchange(xml), expected);
    }

    protected void assertPredicate(String xpath, String xml, boolean expected) {
        XPathBuilder predicate = XPathBuilder.xpath((String)xpath);
        XPathTest.assertPredicate((Predicate)predicate, this.createExchange(xml), expected);
    }

    protected Exchange createExchange(Object xml) {
        Exchange exchange = this.createExchangeWithBody((CamelContext)this.context, xml);
        exchange.getIn().setHeader("name", (Object)"James");
        return exchange;
    }

    public void testXPathNotUsingExchangeMatches() throws Exception {
        XPathTest.assertTrue((boolean)XPathBuilder.xpath((String)"/foo/bar/@xyz").matches((CamelContext)this.context, (Object)"<foo><bar xyz='cheese'/></foo>"));
        XPathTest.assertFalse((boolean)XPathBuilder.xpath((String)"/foo/bar/@xyz").matches((CamelContext)this.context, (Object)"<foo>Hello World</foo>"));
    }

    public void testXPathNotUsingExchangeEvaluate() throws Exception {
        String name = (String)XPathBuilder.xpath((String)"foo/bar").evaluate((CamelContext)this.context, (Object)"<foo><bar>cheese</bar></foo>", String.class);
        XPathTest.assertEquals((String)"<bar>cheese</bar>", (String)name);
        name = (String)XPathBuilder.xpath((String)"foo/bar/text()").evaluate((CamelContext)this.context, (Object)"<foo><bar>cheese</bar></foo>", String.class);
        XPathTest.assertEquals((String)"cheese", (String)name);
        Integer number = (Integer)XPathBuilder.xpath((String)"foo/bar").evaluate((CamelContext)this.context, (Object)"<foo><bar>123</bar></foo>", Integer.class);
        XPathTest.assertEquals((int)123, (int)number);
        Boolean bool = (Boolean)XPathBuilder.xpath((String)"foo/bar").evaluate((CamelContext)this.context, (Object)"<foo><bar>true</bar></foo>", Boolean.class);
        XPathTest.assertEquals((boolean)true, (boolean)bool);
    }

    public void testXPathSplit() throws Exception {
        Object node = XPathBuilder.xpath((String)"foo/bar").nodeResult().evaluate(this.createExchange("<foo><bar>cheese</bar><bar>cake</bar><bar>beer</bar></foo>"));
        XPathTest.assertNotNull((Object)node);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, node);
        XPathTest.assertNotNull((Object)doc);
    }

    public void testXPathSplitConcurrent() throws Exception {
        int size = 100;
        final Object node = XPathBuilder.xpath((String)"foo/bar").nodeResult().evaluate(this.createExchange("<foo><bar>cheese</bar><bar>cake</bar><bar>beer</bar></foo>"));
        XPathTest.assertNotNull((Object)node);
        final ArrayList result = new ArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(size);
        final CountDownLatch latch = new CountDownLatch(size);
        for (int i = 0; i < size; ++i) {
            executor.submit(new Callable<Document>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Document call() throws Exception {
                    try {
                        Document doc = (Document)XPathTest.this.context.getTypeConverter().convertTo(Document.class, node);
                        result.add(doc);
                        Document document = doc;
                        return document;
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        XPathTest.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        Iterator it = result.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            Document doc = (Document)it.next();
            XPathTest.assertNotNull((Object)doc);
        }
        XPathTest.assertEquals((int)size, (int)count);
        executor.shutdownNow();
    }

    public void testXPathNodeListTest() throws Exception {
        String xml = "<foo><person id=\"1\">Claus<country>SE</country></person><person id=\"2\">Jonathan<country>CA</country></person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Object result = XPathBuilder.xpath((String)"/foo/person").nodeSetResult().evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)ObjectHelper.between((String)xml, (String)"<foo>", (String)"</foo>"), (String)s);
    }

    public void testXPathNodeListSimpleTest() throws Exception {
        String xml = "<foo><person>Claus</person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Object result = XPathBuilder.xpath((String)"/foo/person").nodeSetResult().evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"<person>Claus</person>", (String)s);
    }

    public void testXPathNodeListSimpleTestText() throws Exception {
        String xml = "<foo><person>Claus</person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Object result = XPathBuilder.xpath((String)"/foo/person/text()").nodeSetResult().evaluate(this.createExchange(doc));
        XPathTest.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        XPathTest.assertEquals((String)"Claus", (String)s);
    }

    public void testXPathString() throws Exception {
        XPathBuilder builder = XPathBuilder.xpath((String)"foo/bar");
        String name = (String)builder.evaluate((CamelContext)this.context, (Object)"<foo><bar id=\"1\">cheese</bar></foo>", String.class);
        XPathTest.assertEquals((String)"<bar id=\"1\">cheese</bar>", (String)name);
        name = builder.evaluate((CamelContext)this.context, (Object)"<foo><bar id=\"1\">cheese</bar></foo>");
        XPathTest.assertEquals((String)"cheese", (String)name);
    }
}

