/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.MyFooBean;
import org.apache.camel.impl.ProcessorEndpoint;

public class BeanComponentCustomCreateEndpointTest
extends ContextTestSupport {
    public void testCreateEndpoint() throws Exception {
        BeanComponent bc = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        ProcessorEndpoint pe = bc.createEndpoint((Object)new MyFooBean());
        BeanComponentCustomCreateEndpointTest.assertNotNull((Object)pe);
        String uri = pe.getEndpointUri();
        BeanComponentCustomCreateEndpointTest.assertEquals((String)"bean:generated:MyFooBean", (String)uri);
        Producer producer = pe.createProducer();
        Exchange exchange = producer.createExchange();
        exchange.getIn().setBody((Object)"World");
        producer.start();
        producer.process(exchange);
        producer.stop();
        BeanComponentCustomCreateEndpointTest.assertEquals((Object)"Hello World", (Object)exchange.getOut().getBody());
    }

    public void testCreateEndpointUri() throws Exception {
        BeanComponent bc = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        ProcessorEndpoint pe = bc.createEndpoint((Object)new MyFooBean(), "bean:cheese");
        BeanComponentCustomCreateEndpointTest.assertNotNull((Object)pe);
        String uri = pe.getEndpointUri();
        BeanComponentCustomCreateEndpointTest.assertEquals((String)"bean:cheese", (String)uri);
        Producer producer = pe.createProducer();
        Exchange exchange = producer.createExchange();
        exchange.getIn().setBody((Object)"World");
        producer.start();
        producer.process(exchange);
        producer.stop();
        BeanComponentCustomCreateEndpointTest.assertEquals((Object)"Hello World", (Object)exchange.getOut().getBody());
    }
}

