/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanConsumerTemplateTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("cool", (Object)new MyCoolBean());
        return jndi;
    }

    public void testConsumeBeanFromRoute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"start");
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumeBeanFromTemplate() throws Exception {
        Exchange out = this.consumer.receive("bean:cool");
        BeanConsumerTemplateTest.assertEquals((Object)"Hello World", (Object)out.getOut().getBody());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Exchange consumed = BeanConsumerTemplateTest.this.consumer.receive("bean:cool");
                        exchange.getIn().setBody(consumed.getOut().getBody());
                    }
                })).to("mock:result");
            }
        };
    }

    public class MyCoolBean {
        public String say() {
            return "Hello World";
        }
    }
}

