/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.impl.DefaultExchange;

public class BeanExcludedMethodTest
extends ContextTestSupport {
    public void testExcludedMethod() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyDummyBean pojo = new MyDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        BeanExcludedMethodTest.assertNull((String)"Should not be possible to find a suitable method", (Object)mi);
    }

    public void testNotExcludedMethod() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyOtherDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyOtherDummyBean pojo = new MyOtherDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        BeanExcludedMethodTest.assertNotNull((Object)mi);
        BeanExcludedMethodTest.assertEquals((String)"hello", (String)mi.getMethod().getName());
    }

    public static class MyOtherDummyBean {
        public boolean equals(Object obj) {
            TestCase.fail((String)"Should not call equals");
            return true;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "dummy";
        }

        public String hello(String hi) {
            return "Hello " + hi;
        }
    }

    public static class MyDummyBean {
        public boolean equals(Object obj) {
            TestCase.fail((String)"Should not call equals");
            return true;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

