/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.MyStaticClass;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class BeanInvokeStaticTest
extends ContextTestSupport {
    public void testA() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").bean(MyStaticClass.class, "changeSomething")).to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:a");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testB() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").bean(MyStaticClass.class, "doSomething")).to("mock:a");
            }
        });
        try {
            this.context.start();
            BeanInvokeStaticTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            BeanInvokeStaticTest.assertIsInstanceOf(RuntimeCamelException.class, e.getCause());
            BeanInvokeStaticTest.assertIsInstanceOf(MethodNotFoundException.class, e.getCause().getCause());
            BeanInvokeStaticTest.assertEquals((String)"Static method with name: doSomething not found on class: org.apache.camel.component.bean.MyStaticClass", (String)e.getCause().getCause().getMessage());
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

