/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;

public class BeanMapPutTest
extends ContextTestSupport {
    private Map<String, String> myMap = new HashMap<String, String>();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myMap", this.myMap);
        return jndi;
    }

    public void testMapPut() throws Exception {
        BeanMapPutTest.assertEquals((int)0, (int)this.myMap.size());
        this.template.sendBody("direct:start", (Object)"Hello World");
        BeanMapPutTest.assertEquals((int)1, (int)this.myMap.size());
        BeanMapPutTest.assertEquals((String)"true", (String)this.myMap.get("isMaster"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").beanRef("myMap", "put('isMaster','true')");
            }
        };
    }
}

