/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanWithInputStreamBodyTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyCoolBean());
        return jndi;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testBeanWithInputStreamBody() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyCoolBean.class)).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"There is 11 bytes"});
        ByteArrayInputStream bais = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:start", (Object)bais);
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanWithInputStreamBodyMethod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyCoolBean.class, "doSomething")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"There is 11 bytes"});
        ByteArrayInputStream bais = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:start", (Object)bais);
        this.assertMockEndpointsSatisfied();
    }

    public void testToBeanWithInputStreamBody() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"There is 11 bytes"});
        ByteArrayInputStream bais = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:start", (Object)bais);
        this.assertMockEndpointsSatisfied();
    }

    public void testToBeanWithInputStreamBodyMethod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"There is 11 bytes"});
        ByteArrayInputStream bais = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:start", (Object)bais);
        this.assertMockEndpointsSatisfied();
    }

    public void testToBeanWithInputStreamBodyMethodOGNL() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething(${body})")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"There is 11 bytes"});
        ByteArrayInputStream bais = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:start", (Object)bais);
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyCoolBean {
        public static String doSomething(InputStream is) throws IOException {
            int c;
            int byteCount = 0;
            while ((c = is.read()) != -1) {
                ++byteCount;
            }
            return "There is " + byteCount + " bytes";
        }
    }
}

