/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Properties;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithPropertiesAndHeadersAndBodyInjectionTest
extends ContextTestSupport {
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("p1", (Object)"abc");
                exchange.setProperty("p2", (Object)123);
                Message in = exchange.getIn();
                in.setHeader("h1", (Object)"xyz");
                in.setHeader("h2", (Object)456);
                in.setBody((Object)"TheBody");
            }
        });
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertEquals((String)"Should not fail", (boolean)false, (boolean)out.isFailed());
        Map foo = this.myBean.foo;
        Map bar = this.myBean.bar;
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertNotNull((String)"myBean.foo", (Object)foo);
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertNotNull((String)"myBean.bar", (Object)bar);
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertEquals((String)"foo.p1", (Object)"abc", foo.get("p1"));
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertEquals((String)"foo.p2", (Object)123, foo.get("p2"));
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertEquals((String)"bar.h1", (Object)"xyz", bar.get("h1"));
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertEquals((String)"bar.h2", (Object)456, bar.get("h2"));
        BeanWithPropertiesAndHeadersAndBodyInjectionTest.assertEquals((String)"body", (String)"TheBody", (String)this.myBean.body);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        private Map<?, ?> foo;
        private Map<?, ?> bar;
        private String body;

        public String toString() {
            return "MyBean[foo: " + this.foo + " bar: " + this.bar + " body: " + this.body + "]";
        }

        public void myMethod(@Properties Map<?, ?> foo, @Headers Map<?, ?> bar, @Body String body) {
            this.foo = foo;
            this.bar = bar;
            this.body = body;
            TestCase.assertNotNull((Object)this.toString());
        }
    }
}

