/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyCurrency;
import org.apache.camel.component.bean.MyCurrencyBean;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class MyCurrencyBeanTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myCurrencyBean", (Object)new MyCurrencyBean());
        return jndi;
    }

    public void testDisplay() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Currency is $"});
        this.template.sendBody("direct:start", (Object)new MyCurrency("$"));
        this.assertMockEndpointsSatisfied();
    }

    public void testDisplayPrice() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Price is $123"});
        this.template.sendBodyAndHeader("direct:price", (Object)new MyCurrency("$"), "price", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:myCurrencyBean?method=display( ${body} )")).to("mock:result");
                ((RouteDefinition)this.from("direct:price").to("bean:myCurrencyBean?method=displayPrice( ${body}, ${header.price} )")).to("mock:result");
            }
        };
    }
}

