/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyApplicationException;
import org.apache.camel.component.bean.MyCustomException;
import org.apache.camel.component.bean.MyRequest;
import org.apache.camel.component.bean.MyResponse;
import org.apache.camel.component.bean.MyService;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.model.ChoiceDefinition;

public class MyServiceProxyTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        String reply = myService.method("Hello World");
        MyServiceProxyTest.assertEquals((String)"Camel in Action", (String)reply);
    }

    public void testKaboom() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        try {
            myService.method("Kaboom");
            MyServiceProxyTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            MyServiceProxyTest.assertEquals((String)"Damn", (String)e.getMessage());
        }
    }

    public void testCheckedException() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        try {
            myService.method("Tiger in Action");
            MyServiceProxyTest.fail((String)"Should have thrown exception");
        }
        catch (MyApplicationException e) {
            MyServiceProxyTest.assertEquals((String)"No tigers", (String)e.getMessage());
            MyServiceProxyTest.assertEquals((int)9, (int)e.getCode());
        }
    }

    public void testNestedRuntimeCheckedException() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        try {
            myService.method("Donkey in Action");
            MyServiceProxyTest.fail((String)"Should have thrown exception");
        }
        catch (MyApplicationException e) {
            MyServiceProxyTest.assertEquals((String)"No donkeys", (String)e.getMessage());
            MyServiceProxyTest.assertEquals((int)8, (int)e.getCode());
        }
    }

    public void testNestedCheckedCheckedException() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:start"), MyService.class);
        try {
            myService.method("Elephant in Action");
            MyServiceProxyTest.fail((String)"Should have thrown exception");
        }
        catch (MyApplicationException e) {
            MyServiceProxyTest.assertEquals((String)"No elephants", (String)e.getMessage());
            MyServiceProxyTest.assertEquals((int)7, (int)e.getCode());
        }
    }

    public void testRequestAndResponse() throws Exception {
        MyService myService = (MyService)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:request"), MyService.class);
        MyRequest in = new MyRequest();
        in.id = 100;
        in.request = "Camel";
        MyResponse response = myService.call(in);
        MyServiceProxyTest.assertEquals((String)"Get a wrong response id.", (int)100, (int)response.id);
        MyServiceProxyTest.assertEquals((String)"Get a wrong response", (String)"Hi Camel", (String)response.response);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isEqualTo((Object)"Tiger in Action")).throwException((Exception)new MyApplicationException("No tigers", 9))).when(this.body().isEqualTo((Object)"Donkey in Action")).throwException((Exception)((Object)new RuntimeCamelException((Throwable)new MyApplicationException("No donkeys", 8))))).when(this.body().isEqualTo((Object)"Elephant in Action")).throwException((Exception)new MyCustomException("Damn", new MyApplicationException("No elephants", 7)))).when(this.body().isEqualTo((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Damn"))).otherwise().transform((Expression)this.constant("Camel in Action"));
                this.from("direct:request").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        MyRequest request = (MyRequest)exchange.getIn().getBody(MyRequest.class);
                        MyResponse response = new MyResponse();
                        response.id = request.id;
                        response.response = "Hi " + request.request;
                        exchange.getOut().setBody((Object)response);
                    }
                });
            }
        };
    }
}

