/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewInstanceTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected JndiContext jndiContext;

    public void testSendMessageToDifferentBeans() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedBodiesReceived(new Object[]{1, 2});
        this.template.sendBody("direct:start", ExchangePattern.InOut, (Object)"first");
        this.jndiContext.unbind("myBean");
        this.jndiContext.bind("myBean", (Object)new MyBean());
        this.template.sendBody("direct:start", ExchangePattern.InOut, (Object)"second");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        this.jndiContext = new JndiContext();
        this.jndiContext.bind("myBean", (Object)new MyBean());
        return this.jndiContext;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").beanRef("myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        private static int counter;
        private int id = MyBean.generateId();

        protected static synchronized int generateId() {
            return ++counter;
        }

        public String toString() {
            return "MyBean[" + this.id + "]";
        }

        public int read(@Body String body) {
            LOG.info("read() method called with: " + body + " on " + this);
            return this.id;
        }
    }
}

