/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateAsBeanTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyPredicate myPredicate = new MyPredicate();

    public void testSendMessage() throws Exception {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        PredicateAsBeanTest.assertEquals((String)("bean body: " + this.myPredicate), (String)expectedBody, (String)this.myPredicate.body);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myPredicate", (Object)this.myPredicate);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myPredicate");
            }
        };
    }

    public static class MyPredicate
    implements Predicate {
        public String body;

        public boolean matches(Exchange exchange) {
            LOG.info("matches(exchange) called with: " + exchange);
            this.body = (String)exchange.getIn().getBody(String.class);
            return null != this.body && this.body.equals("Wobble");
        }

        public void assertMatches(String text, Exchange exchange) throws AssertionError {
            LOG.info("assertMatches(text, exchange) called with: " + text + ", " + exchange);
        }
    }
}

