/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;

public class ProxyReturnFutureListTest
extends ContextTestSupport {
    public void testFutureList() throws Exception {
        Users service = (Users)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Users.class);
        Future<List<String>> future = service.getUsers(true);
        this.log.info("Got future");
        ProxyReturnFutureListTest.assertFalse((String)"Should not be done", (boolean)future.isDone());
        this.log.info("Waiting for future to be done ...");
        List<String> users = future.get(5L, TimeUnit.SECONDS);
        ProxyReturnFutureListTest.assertEquals((String)"Claus", (String)users.get(0));
        ProxyReturnFutureListTest.assertEquals((String)"Jonathan", (String)users.get(1));
    }

    public void testFutureListCallTwoTimes() throws Exception {
        Users service = (Users)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Users.class);
        Future<List<String>> future = service.getUsers(true);
        this.log.info("Got future");
        ProxyReturnFutureListTest.assertFalse((String)"Should not be done", (boolean)future.isDone());
        this.log.info("Waiting for future to be done ...");
        List<String> users = future.get(5L, TimeUnit.SECONDS);
        ProxyReturnFutureListTest.assertEquals((String)"Claus", (String)users.get(0));
        ProxyReturnFutureListTest.assertEquals((String)"Jonathan", (String)users.get(1));
        future = service.getUsers(true);
        this.log.info("Got future");
        ProxyReturnFutureListTest.assertFalse((String)"Should not be done", (boolean)future.isDone());
        this.log.info("Waiting for future to be done ...");
        users = future.get(5L, TimeUnit.SECONDS);
        ProxyReturnFutureListTest.assertEquals((String)"Claus", (String)users.get(0));
        ProxyReturnFutureListTest.assertEquals((String)"Jonathan", (String)users.get(1));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:echo").delay(2000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ArrayList<String> users = new ArrayList<String>();
                        users.add("Claus");
                        users.add("Jonathan");
                        exchange.getIn().setBody(users);
                    }
                });
            }
        };
    }

    public static interface Users {
        public Future<List<String>> getUsers(boolean var1);
    }
}

