/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;

public class SendBodyToBeanDirectlyTest
extends ContextTestSupport {
    public void testSendBodyToBeanDirectly() throws Exception {
        Object response = this.template.requestBody("bean:one", (Object)"Start:");
        SendBodyToBeanDirectlyTest.assertEquals((Object)"Start:one", (Object)response);
    }

    public void testSendBodyToBeanIndirectly() throws Exception {
        Object response = this.template.requestBody("direct:start", (Object)"Start:");
        SendBodyToBeanDirectlyTest.assertEquals((Object)"Start:onetwo", (Object)response);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("one", (Object)new MyBean("one"));
        answer.bind("two", (Object)new MyBean("two"));
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("bean:one").to("bean:two");
                this.from("direct:start").pipeline(new String[]{"bean:one", "bean:two"});
            }
        };
    }

    public static class MyBean {
        private String postfix;

        public MyBean(String postfix) {
            this.postfix = postfix;
        }

        public String doSomething(String body) {
            return body + this.postfix;
        }
    }
}

