/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.issues.MyLittleBean;
import org.apache.camel.component.bean.issues.MyLittleProcessor;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.util.StopWatch;

public class BeanVsProcessorPerformanceTest
extends ContextTestSupport {
    private final int size = 100000;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myLittleBean", (Object)new MyLittleBean());
        return jndi;
    }

    public void testProcessor() throws Exception {
        StopWatch watch = new StopWatch();
        for (int i = 0; i < 100000; ++i) {
            Object out = this.template.requestBody("direct:a", (Object)("" + i));
            BeanVsProcessorPerformanceTest.assertEquals((Object)("Bye " + i), (Object)out);
        }
        this.log.info("Processor took {} ms ", (Object)watch.taken());
    }

    public void testBean() throws Exception {
        StopWatch watch = new StopWatch();
        for (int i = 0; i < 100000; ++i) {
            Object out = this.template.requestBody("direct:b", (Object)("" + i));
            BeanVsProcessorPerformanceTest.assertEquals((Object)("Bye " + i), (Object)out);
        }
        this.log.info("Bean took {} ms ", (Object)watch.taken());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").process((Processor)new MyLittleProcessor());
                this.from("direct:b").beanRef("myLittleBean", "bye");
            }
        };
    }
}

