/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.dataset.DataSetComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DataSetComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DataSetComponent comp = (DataSetComponent)this.context.getComponent("dataset", DataSetComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("dataset:foo?minRate=3");
        DataSetComponentConfigurationAndDocumentationTest.assertEquals((Object)"3", (Object)conf.getParameter("minRate"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DataSetComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"preloadSize\": { \"type\": \"long\" }"));
        DataSetComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"minRate\": { \"type\": \"int\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (DataSetComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("dataset");
        DataSetComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

