/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DirectComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DirectComponent comp = (DirectComponent)this.context.getComponent("direct", DirectComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("direct:foo?block=true");
        DirectComponentConfigurationAndDocumentationTest.assertEquals((Object)"true", (Object)conf.getParameter("block"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DirectComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DirectComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"timeout\": { \"type\": \"long\" }"));
        DirectComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"block\": { \"type\": \"boolean\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (DirectComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("direct");
        DirectComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

