/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class DirectEndpointRouteInlinedTest
extends ContextTestSupport {
    public void testDirect() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testDirectExistingExists() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("mock:result");
                    this.from("direct:start").to("mock:bar");
                }
            });
            DirectEndpointRouteInlinedTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToStartRouteException e) {
            DirectEndpointRouteInlinedTest.assertEquals((String)"Failed to start route route2 because of Multiple consumers for the same endpoint is not allowed: Endpoint[direct://start]", (String)e.getMessage());
        }
    }
}

