/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;

public class DirectRouteTest
extends TestCase {
    public void testSedaQueue() throws Exception {
        DefaultCamelContext container = new DefaultCamelContext();
        final AtomicBoolean invoked = new AtomicBoolean();
        container.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:test.a").to("direct:test.b");
                this.from("direct:test.b").process(new Processor(){

                    public void process(Exchange e) {
                        invoked.set(true);
                    }
                });
            }
        });
        container.start();
        Endpoint endpoint = container.getEndpoint("direct:test.a");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cheese", (Object)123);
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        DirectRouteTest.assertTrue((String)"Did not receive the message!", (boolean)invoked.get());
        container.stop();
    }
}

