/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;

public class SendToNonExistingDirectEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDirect() throws Exception {
        try {
            this.template.sendBody("direct:foo", (Object)"Hello World");
            SendToNonExistingDirectEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            DirectConsumerNotAvailableException cause = SendToNonExistingDirectEndpointTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
            SendToNonExistingDirectEndpointTest.assertIsInstanceOf(CamelExchangeException.class, cause);
            SendToNonExistingDirectEndpointTest.assertEquals((String)"No consumers available on endpoint: Endpoint[direct://foo]. Exchange[Message: Hello World]", (String)cause.getMessage());
            SendToNonExistingDirectEndpointTest.assertNotNull((Object)cause.getExchange());
        }
    }
}

