/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeAlterFileNameHeaderIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeAlterFileNameHeaderIssueTest.deleteDirectory("target/files");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testConsumeAndDeleteRemoveAllHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files?delete=true").removeHeaders("*")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumeAlterFileNameHeaderIssueTest.assertFalse((String)"Headers should have been removed", (boolean)((Exchange)mock.getExchanges().get(0)).getIn().hasHeaders());
        FileConsumeAlterFileNameHeaderIssueTest.assertFalse((String)"File should been deleted", (boolean)new File("target/files/hello.txt").exists());
    }

    public void testConsumeAndDeleteChangeFileHeader() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files?delete=true").setHeader("CamelFileName", (Expression)this.constant("bye.txt"))).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumeAlterFileNameHeaderIssueTest.assertFalse((String)"File should been deleted", (boolean)new File("target/files/hello.txt").exists());
    }

    public void testConsumeAndMoveRemoveAllHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files").removeHeaders("*")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumeAlterFileNameHeaderIssueTest.assertFalse((String)"Headers should have been removed", (boolean)((Exchange)mock.getExchanges().get(0)).getIn().hasHeaders());
        FileConsumeAlterFileNameHeaderIssueTest.assertTrue((String)"File should been moved", (boolean)new File("target/files/.camel/hello.txt").exists());
    }

    public void testConsumeAndMoveChangeFileHeader() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files").setHeader("CamelFileName", (Expression)this.constant("bye.txt"))).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumeAlterFileNameHeaderIssueTest.assertTrue((String)"File should been moved", (boolean)new File("target/files/.camel/hello.txt").exists());
    }
}

