/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;

public class FileConsumeAsyncTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeAsyncTest.deleteDirectory("target/files");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
    }

    public void testConsumeAsync() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        FileConsumeAsyncTest.assertTrue((String)"File should not have been deleted", (boolean)new File("target/files/report.txt").exists());
        this.oneExchangeDone.matchesMockWaitTime();
        this.assertMockEndpointsSatisfied();
        FileConsumeAsyncTest.assertFalse((String)"File should have been deleted", (boolean)new File("target/files/report.txt").exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)((RouteDefinition)this.from("file://target/files/?delete=true&delay=10000").convertBodyTo(String.class)).threads().to("mock:before")).delay(1000L).to("mock:result");
            }
        };
    }
}

