/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerBatchTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerBatchTest.deleteDirectory("target/file-batch");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file-batch/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/file-batch/", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file-batch?initialDelay=2000").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public void testConsumeBatch() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        ((ValueBuilder)mock.message(0).property("CamelBatchSize")).isEqualTo((Object)2);
        ((ValueBuilder)mock.message(0).property("CamelBatchIndex")).isEqualTo((Object)0);
        ((ValueBuilder)mock.message(1).property("CamelBatchIndex")).isEqualTo((Object)1);
        this.assertMockEndpointsSatisfied();
    }
}

