/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerFileExpressionTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerFileExpressionTest.deleteDirectory("target/filelanguage");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("counter", (Object)new MyGuidGenerator());
        return jndi;
    }

    public void testConsumeFileBasedOnBeanName() throws Exception {
        this.template.sendBodyAndHeader("file://target/filelanguage/bean", (Object)"Hello World", "CamelFileName", (Object)"122.txt");
        this.template.sendBodyAndHeader("file://target/filelanguage/bean", (Object)"Goodday World", "CamelFileName", (Object)"123.txt");
        this.template.sendBodyAndHeader("file://target/filelanguage/bean", (Object)"Bye World", "CamelFileName", (Object)"124.txt");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/filelanguage/bean/?fileName=${bean:counter.next}.txt&delete=true").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        mock.setResultWaitTime(5000L);
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumeFileBasedOnDatePattern() throws Exception {
        this.template.sendBodyAndHeader("file://target/filelanguage/date", (Object)"Bye World", "CamelFileName", (Object)"myfile-20081128.txt");
        this.template.sendBodyAndHeader("file://target/filelanguage/date", (Object)"Hello World", "CamelFileName", (Object)"myfile-20081129.txt");
        this.template.sendBodyAndHeader("file://target/filelanguage/date", (Object)"Goodday World", "CamelFileName", (Object)SimpleLanguage.simple((String)"myfile-${date:now:yyyyMMdd}.txt"));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/filelanguage/date/?fileName=myfile-${date:now:yyyyMMdd}.txt").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        mock.setResultWaitTime(5000L);
        this.assertMockEndpointsSatisfied();
    }

    public class MyGuidGenerator {
        public String next() {
            return "123";
        }
    }
}

