/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerFileFilterTest
extends ContextTestSupport {
    private String fileUrl = "file://target/filefilter/?filter=#myFilter";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myFilter", new MyFileFilter());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileConsumerFileFilterTest.deleteDirectory("target/filefilter");
        super.setUp();
    }

    public void testFilterFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/filefilter/", (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        mock.setResultWaitTime(2000L);
        mock.assertIsSatisfied();
    }

    public void testFilterFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/filefilter/", (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader("file:target/filefilter/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerFileFilterTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public class MyFileFilter<T>
    implements GenericFileFilter<T> {
        public boolean accept(GenericFile<T> file) {
            if (file.isDirectory()) {
                return true;
            }
            return !file.getFileName().startsWith("skip");
        }
    }
}

