/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.util.ObjectHelper;

public class FileConsumerPollStrategyStopOnRollbackTest
extends ContextTestSupport {
    private static int counter;
    private static volatile String event;
    private String fileUrl = "file://target/pollstrategy/?pollStrategy=#myPoll";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FileConsumerPollStrategyStopOnRollbackTest.deleteDirectory("target/pollstrategy");
        this.template.sendBodyAndHeader("file:target/pollstrategy/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testStopOnRollback() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.assertIsSatisfied(2000L);
        FileConsumerPollStrategyStopOnRollbackTest.assertEquals((String)"rollback", (String)event);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerPollStrategyStopOnRollbackTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    static {
        event = "";
    }

    private static class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            try {
                consumer.start();
            }
            catch (Exception e) {
                ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
            if (counter++ == 0) {
                throw new IllegalArgumentException("Damn I cannot do this");
            }
            return true;
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            event = event + "commit";
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
            if (cause.getMessage().equals("Damn I cannot do this")) {
                event = event + "rollback";
                consumer.stop();
            }
            return false;
        }
    }
}

