/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileConsumerRelativeFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerRelativeFileNameTest.deleteDirectory("target/filename-consumer");
        super.setUp();
        this.template.sendBodyAndHeader("file:target/filename-consumer", (Object)"Hello World", "CamelFileName", (Object)"target/filename-consumer-hello.txt");
        this.template.sendBodyAndHeader("file:target/filename-consumer", (Object)"Bye World", "CamelFileName", (Object)"target/filename-consumer-bye.txt");
    }

    public void testValidFilenameOnExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.allMessages().header("CamelFileName")).isNotNull();
        this.assertMockEndpointsSatisfied();
        FileConsumerRelativeFileNameTest.assertDirectoryEquals("target/filename-consumer-bye.txt", (String)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileName", String.class));
        FileConsumerRelativeFileNameTest.assertDirectoryEquals("target/filename-consumer-hello.txt", (String)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getHeader("CamelFileName", String.class));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/filename-consumer?recursive=true&sortBy=file:name").to("mock:result");
            }
        };
    }
}

